﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="LabOrders.aspx.cs" Inherits="LabOrders" MasterPageFile="~/Registry.master"  %>
<%@ Import  Namespace="System.Web.Security.AntiXss" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
    <link type = "text/css" href = "styles/StyleSheet.css" />
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <script type ="text/javascript">

        $(document).ready(function()
        {
            if ($('select.criteria').length > 0)
            {
                if ($('select.criteria').find(":selected").val() == "")
                {
                    $('#<%= ButtonSearch.ClientID %>').attr('disabled', 'disabled');
                    $('#<%= ButtonClear.ClientID %>').attr('disabled', 'disabled');
                }
                else
                {
                    $('#<%= ButtonSearch.ClientID %>').removeAttr('disabled');
                    $('#<%= ButtonClear.ClientID %>').removeAttr('disabled');

                }

            }

            $('select.criteria').change(function()
            {

                $('#<%= TextBoxSearchCriteria.ClientID %>').val('');

                if ($(this).val() == "")
                {
                    $('#<%= ButtonSearch.ClientID %>').attr('disabled', 'disabled');
                    $('#<%= ButtonClear.ClientID %>').attr('disabled', 'disabled');

                }
                else
                {
                    $('#<%= ButtonSearch.ClientID %>').removeAttr('disabled');
                    $('#<%= ButtonClear.ClientID %>').removeAttr('disabled');


                }

            });
            
            if ($('#<%= HiddenFieldClearFlag.ClientID %>').val() === '1')
                $('#<%= TextBoxSearchCriteria.ClientID%>').focus();
        });
    </script>
    <div class="breadcrumb">
        <asp:FormView ID="FormViewBreadCrumb" runat="server" DataSourceID="ObjectDataSourceEFRLabOrderStatus">
            <ItemTemplate>
              <asp:Label SkinID="DataLabel" ID = "BreadCrumbLabel" runat="server" Text='<%# "My Tasks > Lab Orders > " + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("NAME")), false) %>'  />
            </ItemTemplate>
        </asp:FormView>
    </div>
    <br />
    <div class = "excludeSaveWarnings">
        <asp:Label SkinID="DataLabel" ID="LabelSearchCriteria" runat="server" 
            AssociatedControlID="TextBoxSearchCriteria">
            Filter by Last Name:
        </asp:Label>
        <asp:DropDownList ID="DropDownFilterBy" runat="server"
            visible="false" CssClass = "criteria">
            <asp:ListItem Selected="True" 
                Text="(Select value)" 
                value="">
            </asp:ListItem>
            <asp:ListItem 
                Text="Last Name" 
                value="LAST_NAME">
            </asp:ListItem>
            <asp:ListItem 
                Text="BSO Number" 
                value="BSO_NUMBER">
            </asp:ListItem>
            <asp:ListItem 
                Text="Lab Request Number" 
                value="LAB_REQUEST_NUMBER">
            </asp:ListItem>
        </asp:DropDownList>
         
        <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="200px">
        </asp:TextBox>
        &nbsp;
        <asp:Button ID="ButtonSearch" runat="server" 
            Text=" &nbsp;&nbsp;Go&nbsp;&nbsp; " 
            OnClick = "ButtonOK_Click"
        />
        &nbsp;
        <asp:Button ID="ButtonClear" runat="server" 
            Text=" Clear " 
            OnClick = "ButtonClear_Click" 
        />
        <br />
        <asp:HiddenField ID="HiddenFieldClearFlag" runat="server" />
    </div>    
    <asp:GridView ID = "GridViewEFRLabOrders" runat = "server" 
        DataSourceID = "ObjectDataSourceEFRLabOrdersMultipleSearch" 
         
        AutoGenerateColumns = "false"
        AllowPaging="True" 
        PageSize="20" 
        DataKeyNames = "LabOrderId" 
        OnRowCommand = "LabOrders_RowCommand" 
        AllowSorting = "true">
        <EmptyDataTemplate>
            No lab orders matching selection criteria exist in this status
        </EmptyDataTemplate> 
        <Columns>
            <asp:TemplateField 
                HeaderText = "Workflow ID" 
                SortExpression = "Workflow.WKF_CASE_ID" 
                ItemStyle-HorizontalAlign="Center">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID = "LabelCaseID" runat = "server" 
                        Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("CaseId")), false) %>' ></asp:Label> 
                </ItemTemplate> 
            </asp:TemplateField>
            <asp:TemplateField 
                HeaderText = "Lab Request Number" 
                ItemStyle-HorizontalAlign="Center" 
                SortExpression = "AssociatedOrder.LAB_ORDER_ID">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID = "LabelRequestID" runat = "server" 
                        Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("LabRequestId")), false) %>' >
                    </asp:Label> 
                </ItemTemplate> 
            </asp:TemplateField>
            <asp:TemplateField 
                HeaderText="Patient Name" 
                SortExpression = "Workflow.WKF_CASE.PATIENT.LAST_NAME">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelPatientName" runat="server" 
                        Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("PatientName")), false) %>'>
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
             <asp:TemplateField 
                HeaderText="Site Number" 
                SortExpression = "Workflow.WKF_CASE.REFERRAL.STD_INSTITUTION.STATIONNUMBER">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelStationNumber" runat="server" 
                        Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("StationNumber")), false) %>'>
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
             <asp:TemplateField 
                HeaderText="Facility" 
                SortExpression = "Workflow.WKF_CASE.REFERRAL.STD_INSTITUTION.NAME">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelInstitution" runat="server" 
                        Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("Institution")), false) %>'>
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField 
                HeaderText="Lab Request Date" 
                SortExpression = "AssociatedOrder.LAB_SEND_DATE" >
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelLabRequestDate" runat="server" 
                        Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("RequestDate")), false) %>' >
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField 
                HeaderText="Date Received by Metals Lab" 
                SortExpression = "AssociatedOrder.LAB_RETURN_DATE" >
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelDateReceivedByMetalsLab" runat="server" 
                        Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ReceivedByMetalsLabDate")), false) %>' >
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField  
                HeaderText="Lab Report Date" 
                SortExpression = "AssociatedOrder.LAB_RETURN_DATE" >
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelLabReportDate" runat="server" 
                        Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ReportDate")), false) %>' >
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField 
                HeaderText="Status" 
                SortExpression = "Workflow.STD_WKFACTIVITYST.NAME">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelOrderStatus" runat="server" 
                        Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("LabOrderStatus")), false) %>' >
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Specimen Type" SortExpression = "Workflow.WKF_CASE.STD_WKFCASETYPE.Name">
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelOrderType" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("LabOrderType")), false) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="BSO Number" SortExpression = "AssociatedOrder.BSO_NUMBER">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelBSONumber" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("BSONumber")), false) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details" AccessibleHeaderText = "Select"  />
            
        </Columns>
    </asp:GridView>    
    <%--<asp:ObjectDataSource ID="ObjectDataSourceEFRLabOrders" runat="server" 
        SelectMethod="SelectByStatus" 
        SelectCountMethod="SelectByStatusCount" 
        StartRowIndexParameterName="startRow" 
        MaximumRowsParameterName="maxRows" 
        SortParameterName="sort"
        EnablePaging="True" 
        TypeName="VeteransAffairs.Registries.BusinessManager.LabOrderManager">
        <SelectParameters>
            <asp:ControlParameter Name = "searchValue" ControlID = "TextBoxSearchCriteria" DefaultValue = "" />
            <asp:QueryStringParameter Name = "id" QueryStringField = "statusId" DefaultValue="1" /> 
        </SelectParameters>         
   </asp:ObjectDataSource>--%>
    <asp:ObjectDataSource ID="ObjectDataSourceEFRLabOrdersMultipleSearch" runat="server" 
        SelectMethod="SelectByStatus"  
        SelectCountMethod="SelectByStatusCount" 
        StartRowIndexParameterName="startRow" 
        MaximumRowsParameterName="maxRows" 
        SortParameterName="sort"
        EnablePaging="True" 
        TypeName="VeteransAffairs.Registries.BusinessManager.LabOrderManager">
        <SelectParameters>
            <asp:ControlParameter 
                Name = "searchCriteria" 
                ControlID = "DropDownFilterBy" 
                DefaultValue = "LAST_NAME" PropertyName="SelectedValue" />
            <asp:ControlParameter 
                Name = "searchValue" 
                ControlID = "TextBoxSearchCriteria" 
                DefaultValue = "" />
            <asp:QueryStringParameter 
                Name = "id" 
                QueryStringField = "statusId" 
                DefaultValue="1" /> 
        </SelectParameters>         
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID = "ObjectDataSourceEFRLabOrderStatus" runat = "server" 
        SelectMethod = "GetNameByStatusId" 
        TypeName = "VeteransAffairs.Registries.BusinessManager.LabOrderManager">
        <SelectParameters>
            <asp:QueryStringParameter Name = "id" QueryStringField = "statusId" DefaultValue="0" /> 
        </SelectParameters>
   </asp:ObjectDataSource> 
</asp:Content>
